% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr-ughne.R
\name{ughne}
\alias{ughne}
\alias{dughne}
\alias{pughne}
\alias{qughne}
\alias{rughne}
\title{The unit-Half-Normal-E distribution}
\usage{
dughne(x, mu, theta, tau = 0.5, log = FALSE)

pughne(q, mu, theta, tau = 0.5, lower.tail = TRUE, log.p = FALSE)

qughne(p, mu, theta, tau = 0.5, lower.tail = TRUE, log.p = FALSE)

rughne(n, mu, theta, tau = 0.5)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{mu}{location parameter indicating the \eqn{\tau}-th quantile, \eqn{\tau \in (0, 1)}.}

\item{theta}{nonnegative shape parameter.}

\item{tau}{the parameter to specify which quantile is to be used.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq{x})} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dughne} gives the density, \code{pughne} gives the distribution function,
\code{qughne} gives the quantile function and \code{rughne} generates random deviates.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function and random number generation function
for the unit-Half-Normal-E distribution reparametrized in terms of the \eqn{\tau}-th quantile, \eqn{\tau \in (0, 1)}.
}
\details{
Probability density function
\deqn{f(y\mid \alpha ,\theta )=\sqrt{\frac{2}{\pi }}\frac{\theta }{y\left[ -\log\left( y\right) \right] }\left( -{\frac{\log \left( y\right) }{\alpha }} \right)^{\theta }\mathrm{\exp }\left\{ -\frac{1}{2}\left[ -{\frac{\log \left( y\right) }{\alpha }}\right]^{2\theta }\right\}}

Cumulative distribution function
\deqn{F(y\mid \alpha ,\theta )=2\Phi \left[ -\left( -{\frac{\log \left( y\right) }{\alpha }}\right)^{\theta }\right]}

Quantile function
\deqn{Q(\tau \mid \alpha ,\theta )=\exp \left\{ -\alpha \left[ -\Phi^{-1}\left(\frac{\tau }{2}\right) \right]^{\frac{1}{\theta }}\right\}}

Reparameterization
\deqn{\alpha=g^{-1}(\mu )=-\log \left( \mu \right) \left[ -\Phi^{-1}\left( \frac{\tau }{2}\right) \right]^{-\frac{1}{\theta }}}
}
\examples{
set.seed(123)
x <- rughne(n = 1000, mu = 0.5, theta = 2, tau = 0.5)
R <- range(x)
S <- seq(from = R[1], to = R[2], by =  0.01)
hist(x, prob = TRUE, main = 'unit-Half-Normal-E')
lines(S, dughne(x = S, mu = 0.5, theta = 2, tau = 0.5), col = 2)
plot(ecdf(x))
lines(S, pughne(q = S, mu = 0.5, theta = 2, tau = 0.5), col = 2)
plot(quantile(x, probs = S), type = "l")
lines(qughne(p = S, mu = 0.5, theta = 2, tau = 0.5), col = 2)

}
\references{
Korkmaz, M. C., (2020). The unit generalized half normal distribution: A new bounded distribution with inference and application. \emph{University Politehnica of Bucharest Scientific}, \bold{82}(2), 133--140.
}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

André F. B. Menezes \email{andrefelipemaringa@gmail.com}
}
