% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ons_infection_survey.R
\docType{data}
\name{ons_infection_survey}
\alias{ons_infection_survey}
\title{ONS COVID-19 infection survey}
\format{
An object of class \code{grouped_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 9820 rows and 8 columns.
}
\source{
\url{https://www.ons.gov.uk/peoplepopulationandcommunity/healthandsocialcare/conditionsanddiseases/datasets/coronaviruscovid19infectionsurveydata}

Originally licensed under the \href{https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/}{Open Government Licence v3.0}
}
\usage{
data("ons_infection_survey")
}
\description{
The COVID-19 ONS infection survey took a random sample of the population
and provides an estimate of the prevalence of COVID-19 that is theoretically
free from ascertainment bias. This data set is the output of the model based
on underlying data.
}
\details{
\describe{
\item{ \code{code} (chr) }{
The ONS geographical region code
}
\item{ \code{codeType} (chr) }{
The type of ONS geographical code
}
\item{ \code{name} (chr) }{
The ONS geographical region name
}
\item{ \code{date} (date) }{
A date
}
\item{ \code{prevalence.0.5} (dbl) }{
the median proportion of people in the region testing positive for
COVID-19
}
\item{ \code{prevalence.0.025} (dbl) }{
the lower CI of the proportion of people in the region testing
positive for COVID-19
}
\item{ \code{prevalence.0.975} (dbl) }{
the upper CI of the proportion of people in the region testing positive
for COVID-19
}
\item{ \code{denom} (int) }{
the sample size on which this estimate was made (daily rate inferred
from weekly sample sizes.)
}
}
}
\examples{
dplyr::glimpse(ons_infection_survey)
}
\concept{datasets}
\keyword{datasets}
