% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/england_covid.R
\docType{data}
\name{england_covid_positivity}
\alias{england_covid_positivity}
\title{England only COVID-19 case counts with total test numbers}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1413 rows and 6 columns.
}
\source{
\url{https://ukhsa-dashboard.data.gov.uk/covid-19-archive-data-download}

Originally licensed under the \href{https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/}{Open Government Licence v3.0}
}
\usage{
data("england_covid_positivity")
}
\description{
The daily count of COVID-19 new PCR positive cases in England. The denominator
the overall number of PCR tests conducted. This gives us a proportion of
positive tests which can be used to correct for testing effort.
}
\details{
\subsection{\code{england_covid_positivity} dataframe with 2048 rows and 6 columns}{

\describe{
\item{ \code{name} (chr) }{
The region name
}
\item{ \code{code} (chr) }{
The region code
}
\item{ \code{codeType} (chr) }{
The ONS geographical region code type (including year)
}
\item{ \code{date} (date) }{
The date
}
\item{ \code{count} (dbl) }{
the count of PCR test positives
}
\item{ \code{denom} (dbl) }{
the total count of PCR tests conducted on that day
}
}
}
}
\examples{
dplyr::glimpse(england_covid_positivity)
}
\concept{datasets}
\keyword{datasets}
