% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covid_challenge.R
\docType{data}
\name{covid_challenge}
\alias{covid_challenge}
\title{COVID-19 viral load following challenge}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 629 rows and 3 columns.
}
\source{
\url{https://www.nature.com/articles/s41591-022-01780-9/figures/2}
}
\usage{
data("covid_challenge")
}
\description{
Viral load from nasal swabs of subset of positive participants from COVID-19
human challenge study, as detected by Quantitative PCR. Values were mined from
the vector files of the figures. The Y-axis values are approximate as had
to be manually read from the scale.
}
\details{
Data extracted from Killingley et al, 2022, figure 2 "Viral shedding after a
short incubation period peaks rapidly after human SARS-CoV-2 challenge".
Panel A (middle left sub panel).

For datasets compiled from existing literature, Scientific Data’s policy is
that compilers (creators of the secondary compilation dataset and authors of
the associated Data Descriptor) are not required by the journal to ask
permission from the original authors to extract small amounts of numerical
information or other fields. Expected practice is to attribute the original
work via citation.

\describe{
\item{ \code{id} (chr) }{
id a unique ID for participant
}
\item{ \code{log10_viral_load} (dbl) }{
log 10 viral load in copies per millilitre detected
}
\item{ \code{time} (dbl) }{
time of the sample in days from exposure.
}
}
}
\examples{
dplyr::glimpse(covid_challenge)
}
\references{
B. Killingley et al., ‘Safety, tolerability and viral kinetics during SARS-CoV-2 human challenge in young adults’, Nat Med, vol. 28, no. 5, pp. 1031–1041, May 2022, doi: 10.1038/s41591-022-01780-9.
}
\concept{datasets}
\keyword{datasets}
