% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsriadditive.R
\name{plot.tsriadditive}
\alias{plot.tsriadditive}
\title{Plotting Predicted Survival Function or Cumulative Incidence Function with Pointwise Confidence Intervals}
\usage{
\method{plot}{tsriadditive}(x, newtreatment = NULL, newIV = NULL,
  newcovariates = NULL, alpha = 0.05, unit = "", ...)
}
\arguments{
\item{x}{the fitting object after fitting our model}

\item{newtreatment}{a new treatment value}

\item{newIV}{a new instrumental variable value}

\item{newcovariates}{a new observed covariates}

\item{alpha}{the confidence level 1 - alpha for confidence interval}

\item{unit}{the time unit we focus}

\item{...}{the other arguments you want to put in the built-in plot function}
}
\value{
No return value, called for side effects
}
\description{
The function will plot the predicted survival function when fitting a survival model and
the predicted cumulative incidence function when fitting a competing risks model.
Corresponding pointwise confidence intervals at level alpha are also included.
}
\examples{
survtime <- rexp(100)
cause <- rbinom(100, 1, 0.7)
treatment <- rbinom(100, 1, 0.5)
IV <- rnorm(100)
covariates <- rnorm(100)
fit <- tsriadditive(survtime, cause, treatment, IV, covariates)
plot(fit, 1, 0, 0)
}
