% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{sampling_frequency}
\alias{sampling_frequency}
\title{Infers the sampling frequency of a time series}
\usage{
sampling_frequency(x)
}
\arguments{
\item{x}{either an xts object (or one which has an index attribute) else a
vector of class Date or POSIX based time index}
}
\value{
the sampling period (character).
}
\description{
Given either a vector of time indices or an xts object will infer the
sampling frequency.
}
\examples{
w <- sampling_frequency(seq(as.Date("2010-01-01"), as.Date("2011-01-01"), by="weeks"))
m <- sampling_frequency(seq(as.POSIXct("2010-01-01 12:00:00"),
as.POSIXct("2010-01-02 12:00:00"), by="15 mins"))

}
