#'Function to obtain bootstrap covariance matrix
#'
#'@param bootrepl bootsrap replicates
#'@importFrom stats quantile
#'@export

covar.boot <- function(bootrepl)
{

  bootmean <- apply(bootrepl,2,mean)

  bootmean <- matrix(bootmean)

  k <- ncol(bootrepl)###

  M <- matrix(0,k,k)

  R <- nrow(bootrepl)

  for(i in 1:R)
  {
    m <- bootrepl[i,]-bootmean
    M <- M + m%*%t(m)
  }


  covarboot <- (1/R)*M
  return(covarboot)
}
