% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_trend_auto.R
\encoding{UTF-8}
\name{explore_trend_auto}
\alias{explore_trend_auto}
\title{Main dispatcher for trend analysis based on data type /
Hauptverzweiger fuer Trendanalyse basierend auf Datentyp}
\usage{
explore_trend_auto(
  df,
  datum_col,
  value_col,
  group_col = NULL,
  family = "auto",
  kdf = 3,
  return_formula = FALSE,
  verbose = FALSE,
  control = NULL
)
}
\arguments{
\item{df}{Data frame with time series data. / Data Frame mit Zeitreihendaten.}

\item{datum_col}{Name of the date/time column. / Name der Datums- oder Zeitspalte.}

\item{value_col}{Name of the dependent variable column. / Name der abhaengigen Variablen.}

\item{group_col}{Optional. Name of the grouping column. / Optional. Name der Gruppierungsvariable.}

\item{family}{Model family to use: "auto", "poisson", "negbin", "zip", "zinb", "gaussian", etc. Passed to sub-functions. /
Modellfamilie: "auto", "poisson", "negbin", "zip", "zinb", "gaussian" usw. Wird an Unterfunktionen weitergegeben.}

\item{kdf}{Basis dimension for spline terms (k for GAM or ZI models). / Basisdimension fuer Splines (k bei GAM oder ZI-Modellen).}

\item{return_formula}{If TRUE, return only the model formula without fitting. / Bei TRUE wird nur die Modellformel zurueckgegeben.}

\item{verbose}{If TRUE, print detailed messages. / Bei TRUE werden Diagnosemeldungen ausgegeben.}

\item{control}{Optional control parameters for model fitting (e.g., maxit). / Optionale Steuerparameter fuer die Modellanpassung.}
}
\value{
Result from the appropriate trend analysis function. /
Rueckgabe des Ergebnisses der ausgewaehlten Trendanalysefunktion (z.B. explore_poisson_trend()).
}
\description{
Automatically selects and calls the appropriate trend analysis function depending on whether the data is count-based or continuous. /
Waehlt automatisch die passende Trendanalyse-Funktion basierend auf Zaehldaten oder stetigen Daten.
}
\examples{
# Simulated count data (Poisson)
df <- data.frame(
  datum = seq.Date(from = as.Date("2023-01-01"), by = "day", length.out = 100),
  value = rpois(100, lambda = 5)
)
explore_trend_auto(df, datum_col = "datum", value_col = "value")

# Beispiel mit kontinuierlichen Werten
df2 <- data.frame(
  datum = seq.Date(from = as.Date("2023-01-01"), by = "day", length.out = 100),
  value = sin(1:100 / 10) + rnorm(100)
)
explore_trend_auto(df2, datum_col = "datum", value_col = "value")

}
\seealso{
[explore_poisson_trend()], [explore_zinb_trend()], [explore_continuous_trend()], [infer_value_type()], [prepare_group_data()]
}
