% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_descendant_count}
\alias{node_descendant_count}
\title{Node descendant count}
\usage{
node_descendant_count(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
A single double.
}
\description{
Returns the number of descendants of this node, including this node in the
count.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Top level program node
node_descendant_count(node)

# The whole `<-` binary operator node
node <- node_child(node, 1)
node_descendant_count(node)

# Just the literal `<-` operator itself
node <- node_child_by_field_name(node, "operator")
node_descendant_count(node)
\dontshow{\}) # examplesIf}
}
