% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{repeat_table_to_fragments}
\alias{repeat_table_to_fragments}
\title{Convert Repeat Table to Repeats Fragments}
\usage{
repeat_table_to_fragments(df, min_repeat = 0, max_repeat = 1000)
}
\arguments{
\item{df}{A data frame containing the repeat data with the columns "unique_id", "repeats", "signal".}

\item{min_repeat}{minimum repeat size}

\item{max_repeat}{maximum repeat size}
}
\value{
A list of fragments objects.
}
\description{
This function converts a repeat table data frame into a list of fragments. class.
}
\details{
This function takes a repeat table data frame and converts it into a list of fragments objects. The column names must be "unique_id" (unique sample id), "repeats" (number of repeats), and "signal" (the signal associated with the number of repeats. for example a frequency count of reads.). The dataframe should be long (eg bind rows if the data are separate).
}
\examples{
repeat_table <- trace::example_data_repeat_table
test_fragments <- repeat_table_to_fragments(repeat_table)
}
