% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_runtoxdrc.R
\name{toxdrc_modelling}
\alias{toxdrc_modelling}
\title{Modelling configuration for for the runtoxdrc pipeline.}
\usage{
toxdrc_modelling(
  model.list = list(LL.4 = LL.4(), LN.4 = LN.4(), W1.4 = W1.4(), W2.4 = W2.4()),
  model.metric = c("IC", "Res var", "Lack of fit"),
  EDx = 0.5,
  interval = c("tfls", "fls", "delta", "none"),
  level = 0.95,
  type = c("relative", "absolute"),
  quiet = FALSE,
  EDargs.supplement = list()
)
}
\arguments{
\item{model.list}{List. Model functions to be tested. Defaults to
 include `"LL.4"`, `"LN.4"`, `"W1.4"`, `"W2.4"`. Most models from the drc
 package are compatible; use `drc::getMeanFunctions()` for a more options. See
[modelcomp()] for more information around formatting.}

\item{model.metric}{Character. Criterion used to select the best
model. Choices are `"IC"`, `"Res var"`, `"Lack of fit"`. Defaults
to "IC".}

\item{EDx}{Numeric. The effective dose level to estimate. Defaults
to 0.5.}

\item{interval}{Character. Method for calculating confidence intervals
of EDx. Choices: `"tfls"`, `"fls"`, `"delta"`, `"none"`. Defaults
to "tfls". See `drc::ED()` for more information.}

\item{level}{Numeric. Confidence level for the interval calculation.
Defaults to 0.95.}

\item{type}{Character. Indicates if EDx is `"absolute"` or
`"relative"` to the curve. Defaults to absolute.}

\item{quiet}{Logical. Indicates if results should be hidden. Defaults
to FALSE.}

\item{EDargs.supplement}{List. Optional user-supplied list of additional arguments
compatible with `drc::ED()`.}
}
\value{
A named list containing model fitting and selection settings
 for use in [runtoxdrc()].
}
\description{
Defines how dose-response models are fitted, selected, and how point
 estimates (EDx) are calculated.
}
\examples{
toxdrc_modelling(EDargs.supplement = list(interval = "delta", level = 0.9))

}
\seealso{
[config_runtoxdrc], [runtoxdrc()], [drc::ED()], [getMeanFunctions()], [modelcomp()]
}
