% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{print.topolow}
\alias{print.topolow}
\title{Print method for topolow objects}
\usage{
\method{print}{topolow}(x, ...)
}
\arguments{
\item{x}{A \code{topolow} object returned by \code{euclidean_embedding()}.}

\item{...}{Additional arguments passed to print (not used).}
}
\value{
The original \code{topolow} object (invisibly). This function is called for its
side effect of printing a summary to the console.
}
\description{
Provides a concise display of key optimization results from \code{euclidean_embedding}.
}
\examples{
# Create a simple dissimilarity matrix and run the optimization
dist_mat <- matrix(c(0, 2, 3, 2, 0, 4, 3, 4, 0), nrow=3)
result <- euclidean_embedding(dist_mat, ndim=2, mapping_max_iter=50,
                           k0=1.0, cooling_rate=0.001, c_repulsion=0.1,
                           verbose = FALSE)
# Print the result object
print(result)
}
