% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_time_series.R
\name{db_ts_delete}
\alias{db_ts_delete}
\title{Remove Time Series from the Database}
\usage{
db_ts_delete(con, ts_keys, schema = "timeseries", skip_checks = FALSE)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{ts_keys}{\strong{character} vector of time series identifiers.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}

\item{skip_checks}{boolean should checks be skipped? Use with caution and only in batch mode! Defaults to FALSE.}
}
\description{
This function completely removes a time series from the database, including
all vintages and metadata.
}
\details{
Due to the potentially severe consequences of such a deletion only timeseries
admins may perform this action and should do so very diligently.
}
\examples{

\dontrun{
# Store zrh_airport data
db_ts_store(con = connection, zrh_airport, schema = "schema")

# Deleting one key
db_ts_delete(
  con = connection,
  ts_keys = "ch.zrh_airport.departure.total",
  schema = "schema"
)

# Deleting multiple keys
db_ts_delete(
  con = connection,
  ts_keys = c(
    "ch.zrh_airport.departure.total",
    "ch.zrh_airport.arrival.total"
  ),
  schema = "schema"
)
}
}
\seealso{
Other time series functions: 
\code{\link{db_collection_read_ts}()},
\code{\link{db_dataset_read_ts}()},
\code{\link{db_ts_delete_latest_version}()},
\code{\link{db_ts_get_last_update}()},
\code{\link{db_ts_read_history}()},
\code{\link{db_ts_read}()},
\code{\link{db_ts_store}()},
\code{\link{db_ts_trim_history}()}
}
\concept{time series functions}
