% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-Spat.R
\name{fortify.Spat}
\alias{fortify.Spat}
\alias{fortify.SpatRaster}
\alias{fortify.SpatVector}
\alias{fortify.SpatGraticule}
\alias{fortify.SpatExtent}
\title{Fortify \verb{Spat*} Objects}
\usage{
\method{fortify}{SpatRaster}(
  model,
  data,
  ...,
  .name_repair = "unique",
  maxcell = terra::ncell(model) * 1.1,
  pivot = FALSE
)

\method{fortify}{SpatVector}(model, data, ...)

\method{fortify}{SpatGraticule}(model, data, ...)

\method{fortify}{SpatExtent}(model, data, ..., crs = "")
}
\arguments{
\item{model}{A \code{SpatRaster} created with \code{\link[terra:rast]{terra::rast()}} or a \code{SpatVector}
created with \code{\link[terra:vect]{terra::vect()}}. Also support \code{SpatGraticule} (see
\code{\link[terra:graticule]{terra::graticule()}}) and \code{SpatExtent} (see \code{\link[terra:ext]{terra::ext()}}).}

\item{data}{Not used by this method.}

\item{...}{Ignored by these methods.}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence.
\item \code{"unique"}: Make sure names are unique and not empty.
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique}.
\item \code{"universal"}: Make the names \code{unique} and syntactic.
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base \strong{R}).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}.
}}

\item{maxcell}{positive integer. Maximum number of cells to use for
the plot.}

\item{pivot}{Logical. When \code{TRUE} the \code{SpatRaster} would be provided on
\link[tidyr:pivot_longer]{long format}. When \code{FALSE} (the default) it would
be provided as a data frame with a column for each layer. See \strong{Details}.}

\item{crs}{Input potentially including or representing a CRS. It could be
a \code{sf/sfc} object, a \code{SpatRaster/SpatVector} object, a \code{crs} object from
\code{\link[sf:st_crs]{sf::st_crs()}}, a character (for example a \href{https://proj.org/en/9.3/operations/projections/index.html}{proj4 string}) or a
integer (representing an \href{https://epsg.io/}{EPSG} code).}
}
\value{
\code{\link[=fortify.SpatVector]{fortify.SpatVector()}}, \code{\link[=fortify.SpatGraticule]{fortify.SpatGraticule()}} and \code{\link[=fortify.SpatExtent]{fortify.SpatExtent()}}
return a \code{\link[sf:sf]{sf}} object.

\code{\link[=fortify.SpatRaster]{fortify.SpatRaster()}} returns a \link[tibble:tbl_df-class]{tibble}. See \strong{Methods}.
}
\description{
Fortify \code{SpatRaster} and \code{SpatVector} objects to data frames. This provide
native compatibility with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.

\strong{Note that} these methods are now implemented as a wrapper of \code{\link{tidy.Spat}}
methods.
}
\section{Methods}{


Implementation of the \strong{generic} \code{\link[ggplot2:fortify]{ggplot2::fortify()}} method.
\subsection{\code{SpatRaster}}{

Return a tibble than can be used with \verb{ggplot2::geom_*} like
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}, \code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}}, etc.

The resulting tibble includes the coordinates on the columns \verb{x, y}. The
values of each layer are included as additional columns named as per the
name of the layer on the \code{SpatRaster}.

The CRS of the \code{SpatRaster} can be retrieved with
\code{attr(fortifiedSpatRaster, "crs")}.

It is possible to convert the fortified object onto a \code{SpatRaster} again with
\code{\link[=as_spatraster]{as_spatraster()}}.

When \code{pivot = TRUE} the \code{SpatRaster} is fortified in a "long" format (see
\code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}). The fortified object would have the following
columns:
\itemize{
\item \verb{x,y}: Coordinates (center) of the cell on the corresponding CRS.
\item \code{lyr}: Indicating the name of the \code{SpatRaster} layer of \code{value}.
\item \code{value}: The value of the \code{SpatRaster} in the corresponding \code{lyr}.
}

This option may be useful when using several \verb{geom_*} and for faceting, see
\strong{Examples}.
}

\subsection{\code{SpatVector}, \code{SpatGraticule} and \code{SpatExtent}}{

Return a \code{\link[sf:sf]{sf}} object than can be used with \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.
}
}

\examples{
\donttest{

# Demonstrate the use with ggplot2
library(ggplot2)


# Get a SpatRaster
r <- system.file("extdata/volcano2.tif", package = "tidyterra") |>
  terra::rast() |>
  terra::project("EPSG:4326")


# You can now use a SpatRaster with any geom
ggplot(r, maxcell = 50) +
  geom_histogram(aes(x = elevation),
    bins = 20, fill = "lightblue",
    color = "black"
  )

# For SpatVector, SpatGraticule and SpatExtent you can use now geom_sf()

# Create a SpatVector
extfile <- system.file("extdata/cyl.gpkg", package = "tidyterra")
cyl <- terra::vect(extfile)

class(cyl)

ggplot(cyl) +
  geom_sf()

# SpatGraticule
g <- terra::graticule(60, 30, crs = "+proj=robin")

class(g)

ggplot(g) +
  geom_sf()

# SpatExtent
ex <- terra::ext(cyl)

class(ex)

ggplot(ex, crs = cyl) +
  geom_sf(fill = "red", alpha = 0.3) +
  geom_sf(data = cyl, fill = NA)
}

}
\seealso{
\code{\link{tidy.Spat}}, \code{\link[sf:st_as_sf]{sf::st_as_sf()}}, \code{\link{as_tibble.Spat}},
\code{\link[=as_spatraster]{as_spatraster()}}, \code{\link[ggplot2:fortify]{ggplot2::fortify()}}.

Other \CRANpkg{ggplot2} utils:
\code{\link{autoplot.Spat}},
\code{\link{geom_spat_contour}},
\code{\link{geom_spatraster}()},
\code{\link{geom_spatraster_rgb}()},
\code{\link{ggspatvector}},
\code{\link{stat_spat_coordinates}()}

Other \CRANpkg{ggplot2} methods:
\code{\link{autoplot.Spat}}

Coercing objects:
\code{\link{as_coordinates}()},
\code{\link{as_sf}()},
\code{\link{as_spatraster}()},
\code{\link{as_spatvector}()},
\code{\link{as_tibble.Spat}},
\code{\link{tidy.Spat}}
}
\concept{coerce}
\concept{ggplot2.methods}
\concept{ggplot2.utils}
