% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidymodl.R
\name{tidymodl}
\alias{tidymodl}
\title{Creates a model matrix style R6 class for modelling with long tidy
data}
\description{
Creates a model matrix style R6 class for modelling with long tidy data
}
\note{
Use Cases 1 and 3 return identical results.
}
\examples{
data(wb)
mdl <- tidymodl$new(wb,
                   pivot_column = "indicator",
                  pivot_value = "value")
### Use mdl$child for modelling
fit <- lm(data = mdl$child, gni ~ gcu + ppt)

### Can be used to add a yhat value for processed data

nc <- ncol(mdl$child)
nr <- nrow(mdl$child)
dm <- nc * nr
dummy <- matrix(runif(dm),
                ncol = nc) |>
                data.frame()
names(dummy) = names(mdl$child)
tmp <- mdl$assemble(dummy)

# In built correlation function
mdl$correlate()

tmp <- mdl$pca()
plot(tmp, choix = "var")

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{(\code{data.frame()})\cr
The original tidy long data frame}

\item{\code{parent}}{(\code{data.frame()})\cr
The parent identifiers of the original data}

\item{\code{child}}{(\code{data.frame()})\cr
The model matrix version of the data}

\item{\code{key}}{(\code{data.frame()})\cr
A \verb{key value} table that links the parent
and child data.frames.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-tidymodl-new}{\code{tidymodl$new()}}
\item \href{#method-tidymodl-assemble}{\code{tidymodl$assemble()}}
\item \href{#method-tidymodl-print}{\code{tidymodl$print()}}
\item \href{#method-tidymodl-correlate}{\code{tidymodl$correlate()}}
\item \href{#method-tidymodl-pca}{\code{tidymodl$pca()}}
\item \href{#method-tidymodl-clone}{\code{tidymodl$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tidymodl-new"></a>}}
\if{latex}{\out{\hypertarget{method-tidymodl-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.


Create a new tidymodl object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidymodl$new(df, pivot_column, pivot_value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{A tidy long data frame}

\item{\code{pivot_column}}{The column name on which the pivot will occur}

\item{\code{pivot_value}}{The column name of the values to be pivotted}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{tidymodl} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tidymodl-assemble"></a>}}
\if{latex}{\out{\hypertarget{method-tidymodl-assemble}{}}}
\subsection{Method \code{assemble()}}{
Adds a results matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidymodl$assemble(newdata, format = "long")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{A new data set to append. Needs to be either:
\itemize{
\item A vector of length equal to the number of rows in the model matrix.
For example, the output of \code{predict()} of a \code{lm} model.
In this case the function returns a data.frame of dimensions
\code{c(nrow(parent), ncol(parent) + 1)}
\item A data.frame/matrix of equal dimensions of the model matrix.
For example, the output of \code{xgb_impute()}.
In this case the function returns a data.frame of dimensions
\code{c(nrow(data), ncol(data) + 1)}
}}

\item{\code{format}}{The desired format of the returned data frame, can either
be "long" or "wide".}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This returns a completed data.frame for four use cases based on user
preference of the desired format.
\itemize{
\item \strong{Format "long":}
\itemize{
\item \strong{Use Case 1 - "newdata" is a vector of length nrow(child):}
The function returns a combined data frame of the parent data and the
"newdata" in a new column. Useful when the user wants to append an
output of, for example, \code{predict} for a \code{lm} regression model.
\item \strong{Use Case 2 - "newdata" is a matrix of dimensions
dim(child):} The function returns a data.frame of the original data in
long format with the "newdata" in a new column. Useful when the user
wants to append an output of, for example, \code{xgb_impute} for all original
data.
}
\item \strong{Format "wide":}
\itemize{
\item \strong{Use Case 3 - "newdata" is a vector of length nrow(child):}
The function returns a combined data frame of the parent data and the
"newdata" in a new column. Useful when the user wants to append an
output of, for example, \code{predict} for a \code{lm} regression model.
\item \strong{Use Case 4 - "newdata" is a matrix of dimensions
dim(child):} The function returns a data.frame of the original data in
wide format with the "newdata" as replacing the child matrix of the
original data. Useful when the user \emph{is only} interested in using
the output of, for example, \code{xgb_impute} for all original data.
}
}
}

\subsection{Returns}{
df A Data Frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tidymodl-print"></a>}}
\if{latex}{\out{\hypertarget{method-tidymodl-print}{}}}
\subsection{Method \code{print()}}{
Prints the key and the head matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidymodl$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tidymodl-correlate"></a>}}
\if{latex}{\out{\hypertarget{method-tidymodl-correlate}{}}}
\subsection{Method \code{correlate()}}{
Correlates and reutrns pearson values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidymodl$correlate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
df A Correlation Matrix of class \code{cor_df} (see
\href{https://CRAN.R-project.org/package=corrr}{corrr})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tidymodl-pca"></a>}}
\if{latex}{\out{\hypertarget{method-tidymodl-pca}{}}}
\subsection{Method \code{pca()}}{
Provides high level principal components analysis
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidymodl$pca()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
df A principle components of class \code{PCA} (see
\href{https://CRAN.R-project.org/package=FactoMineR}{FactoMineR}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tidymodl-clone"></a>}}
\if{latex}{\out{\hypertarget{method-tidymodl-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidymodl$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
