% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised-distance.R
\name{tidy_gower}
\alias{tidy_gower}
\title{Gower Distance Calculation}
\usage{
tidy_gower(data, weights = NULL)
}
\arguments{
\item{data}{A data frame or tibble}

\item{weights}{Optional named vector of variable weights (default: equal weights)}
}
\value{
A dist object containing Gower distances
}
\description{
Computes Gower distance for mixed data types (numeric, factor, ordered)
}
\details{
Gower distance handles mixed data types:
\itemize{
\item Numeric: range-normalized Manhattan distance
\item Factor/Character: 0 if same, 1 if different
\item Ordered: treated as numeric ranks
}

Formula: d_ij = sum(w_k * d_ijk) / sum(w_k)
where d_ijk is the dissimilarity for variable k between obs i and j
}
\examples{
# Create example data with mixed types
car_data <- data.frame(
  horsepower = c(130, 250, 180),
  weight = c(1200, 1650, 1420),
  color = factor(c("red", "black", "blue"))
)

# Compute Gower distance
gower_dist <- tidy_gower(car_data)

}
