% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_api.R
\name{estimate_QoI}
\alias{estimate_QoI}
\title{Estimate Quantities of Interest}
\usage{
estimate_QoI(data, ...)
}
\arguments{
\item{data}{data frame (already prepared with \code{attach_config}, \code{make_splits},
\code{produce_plugin_estimates} and \code{construct_pseudo_outcomes})}

\item{...}{Unquoted names of moderators to calculate QoIs for.}
}
\description{
\code{estimate_QoI} takes a dataframe already prepared with split IDs,
plugin estimates and pseudo-outcomes and calculates the requested
quantities of interest (QoIs).
}
\details{
To see an example analysis, read \code{vignette("experimental_analysis")} in the context
of an experiment, \code{vignette("experimental_analysis")} for an observational study, or
\code{vignette("methodological_details")} for a deeper dive under the hood.
}
\examples{
library("dplyr")
if(require("palmerpenguins")) {
data(package = 'palmerpenguins')
penguins$unitid = seq_len(nrow(penguins))
penguins$propensity = rep(0.5, nrow(penguins))
penguins$treatment = rbinom(nrow(penguins), 1, penguins$propensity)
cfg <- basic_config() \%>\% 
add_known_propensity_score("propensity") \%>\%
add_outcome_model("SL.glm.interaction") \%>\%
remove_vimp()
attach_config(penguins, cfg) \%>\%
make_splits(unitid, .num_splits = 4) \%>\%
produce_plugin_estimates(outcome = body_mass_g, treatment = treatment, species, sex) \%>\%
construct_pseudo_outcomes(body_mass_g, treatment) \%>\%
estimate_QoI(species, sex)
}
}
\seealso{
\code{\link[=attach_config]{attach_config()}}, \code{\link[=make_splits]{make_splits()}}, \code{\link[=produce_plugin_estimates]{produce_plugin_estimates()}},
\code{\link[=construct_pseudo_outcomes]{construct_pseudo_outcomes()}},
}
