% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{dt_unnest}
\alias{dt_unnest}
\title{Unnest: Fast Unnesting of Data Tables}
\usage{
dt_unnest(dt_, col, keep = TRUE)
}
\arguments{
\item{dt_}{the data table to unnest}

\item{col}{the column to unnest}

\item{keep}{whether to keep the nested column, default is \code{TRUE}}
}
\description{
Quickly unnest data tables, particularly those nested by \code{dt_nest()}.
}
\examples{

library(data.table)
dt <- data.table(
  x = rnorm(1e5),
  y = runif(1e5),
  grp = sample(1L:3L, 1e5, replace = TRUE)
)

nested <- dt_nest(dt, grp)
dt_unnest(nested, col = data)
}
