% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tic_analyse.R
\name{tic_analyse}
\alias{tic_analyse}
\title{Plot and analyse time-intensity data}
\usage{
tic_analyse(
  data,
  timevar,
  intensityvar,
  loess.span = 0.1,
  AUCmax = NULL,
  peakproportion = NULL,
  calc_wir = FALSE,
  calc_wor = FALSE,
  plotresult = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe with time and intensity values as columns.}

\item{timevar}{A character string (in quotes) with the dataframe column name for the time variable.}

\item{intensityvar}{A character string (in quotes) with dataframe column name for the intensity variable.}

\item{loess.span}{A number between 0 and 1, with larger values resulting in a smoother curve.}

\item{AUCmax}{A number - the maximum time that area under the curve is measured until.}

\item{peakproportion}{A number between 0 and 1 which is used in the time to peak proportion calculations.}

\item{calc_wir}{TRUE or FALSE to determine whether WiR is calculated.}

\item{calc_wor}{TRUE or FALSE to determine whether WoR is calculated.}

\item{plotresult}{TRUE or FALSE to determine whether a plot of the results is generated.}

\item{...}{Additional arguments to be passed into the loess() function.}
}
\value{
A dataframe with the results. Depending on the plotresult argument can also
return a plot of the smoothed curve.
}
\description{
This function plots and analyzes time-intensity data, such as data from (contrast-enhanced)
ultrasound cineloops. Peak intensity and time to peak intensity are calculated from a smoothed
curve through the data (loess smoother). Area under the curve is calculated from the raw data
using the trapezium method for integration. Time to peak proportion (for example time to
90 percent of peak) can also be calculated. If selected, WiR (wash in rate) is the maximum upslope before
the peak value. If selected, WoR (wash out rate) is the absolute value of the maximum downslope following
the peak value (with larger values representing higher wash out rate). Both WiR and WoR are calculated
based on the slope of the LOESS curve, as they are sensitive to noise in the raw data.
}
\details{
Blue dashed lines represent peak and time to peak values. If selected, solid purple lines
represent WiR and WoR, and dashed green lines represent time to peak proportion.

A plot of the data is generated and a dataframe with the results is returned.
}
\examples{

# Example usage: Please see package vignettes on CRAN

}
