% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_outer_smooth.R
\name{generate_smooth_envelope}
\alias{generate_smooth_envelope}
\title{Generate smooth envelope around surface}
\usage{
generate_smooth_envelope(
  surface_path,
  save_as = NULL,
  inflate = 3,
  verbose = TRUE,
  save_format = c("auto", "bin", "asc", "vtk", "ply", "off", "obj", "gii", "mz3", "byu")
)
}
\arguments{
\item{surface_path}{path to \code{'*h.pial'} surface in the 'FreeSurfer'
folder, or a 3-dimensional mesh, see
\code{\link[freesurferformats]{read.fs.surface}}}

\item{save_as}{save final envelope to path, or \code{NULL} for dry-run}

\item{inflate}{number of \code{'voxels'} to inflate before fitting envelope;
must be a non-negative integer}

\item{verbose}{whether to verbose the progress; default is true}

\item{save_format}{format of saved file when \code{save_as} is not
\code{NULL}; see \code{format} argument in function
\code{\link[freesurferformats]{write.fs.surface}}}
}
\value{
A 3-dimensional mesh that contains vertices and face indices,
the result is also saved to \code{save_as} is specified.
}
\description{
Alternative to 'Matlab' version of \code{'pial-outer-smoothed'},
use this function along with \code{\link[ravetools]{fill_surface}}.
}
\examples{

if(interactive() &&
   file.exists(file.path(default_template_directory(), "N27"))) {

library(threeBrain)

fs_path <- file.path(default_template_directory(), "N27")

# lh.pial-outer-smoothed
lh_pial <- file.path(fs_path, "surf", "lh.pial")
save_as <- file.path(fs_path, "surf", "lh.pial-outer-smoothed")
generate_smooth_envelope(lh_pial, save_as)

# rh.pial-outer-smoothed
rh_pial <- file.path(fs_path, "surf", "rh.pial")
save_as <- file.path(fs_path, "surf", "rh.pial-outer-smoothed")
generate_smooth_envelope(rh_pial, save_as)

brain <- threeBrain(
  path = fs_path, subject_code = "N27",
  surface_types = 'pial-outer-smoothed'
)
brain$plot(controllers = list(
  "Surface Type" = 'pial-outer-smoothed'
))

}

}
