% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_autoregressive}
\alias{sts_autoregressive}
\title{Formal representation of an autoregressive model.}
\usage{
sts_autoregressive(
  observed_time_series = NULL,
  order,
  coefficients_prior = NULL,
  level_scale_prior = NULL,
  initial_state_prior = NULL,
  coefficient_constraining_bijector = NULL,
  name = NULL
)
}
\arguments{
\item{observed_time_series}{optional \code{float} \code{tensor} of shape
\verb{batch_shape + [T, 1]} (omitting the trailing unit dimension is also
supported when \code{T > 1}), specifying an observed time series.
Any priors not explicitly set will be given default values according to
the scale of the observed time series (or batch of time series). May
optionally be an instance of \code{sts_masked_time_series}, which includes
a mask \code{tensor} to specify timesteps with missing observations.
Default value: \code{NULL}.}

\item{order}{scalar positive \code{integer} specifying the number of past
timesteps to regress on.}

\item{coefficients_prior}{optional \code{Distribution} instance specifying a
prior on the \code{coefficients} parameter. If \code{NULL}, a default standard
normal (\code{tfd_multivariate_normal_diag(scale_diag = tf$ones(list(order)))}) prior
is used. Default value: \code{NULL}.}

\item{level_scale_prior}{optional \code{Distribution} instance specifying a prior
on the \code{level_scale} parameter. If \code{NULL}, a heuristic default prior is
constructed based on the provided \code{observed_time_series}. Default value: \code{NULL}.}

\item{initial_state_prior}{optional \code{Distribution} instance specifying a
prior on the initial state, corresponding to the values of the process
at a set of size \code{order} of imagined timesteps before the initial step.
If \code{NULL}, a heuristic default prior is constructed based on the
provided \code{observed_time_series}. Default value: \code{NULL}.}

\item{coefficient_constraining_bijector}{optional \code{Bijector} instance
representing a constraining mapping for the autoregressive coefficients.
For example, \code{tfb_tanh()} constrains the coefficients to lie in
\verb{(-1, 1)}, while \code{tfb_softplus()} constrains them to be positive, and
\code{tfb_identity()} implies no constraint. If \code{NULL}, the default behavior
constrains the coefficients to lie in \verb{(-1, 1)} using a \code{tanh} bijector.
Default value: \code{NULL}.}

\item{name}{the name of this model component. Default value: 'Autoregressive'.}
}
\value{
an instance of \code{StructuralTimeSeries}.
}
\description{
An autoregressive (AR) model posits a latent \code{level} whose value at each step
is a noisy linear combination of previous steps:

\if{html}{\out{<div class="sourceCode">}}\preformatted{level[t+1] = (sum(coefficients * levels[t:t-order:-1]) + Normal(0., level_scale))
}\if{html}{\out{</div>}}
}
\details{
The latent state is \code{levels[t:t-order:-1]}. We observe a noisy realization of
the current level: \code{f[t] = level[t] + Normal(0., observation_noise_scale)} at
each timestep.

If \verb{coefficients=[1.]}, the AR process is a simple random walk, equivalent to
a \code{LocalLevel} model. However, a random walk's variance increases with time,
while many AR processes (in particular, any first-order process with
\code{abs(coefficient) < 1}) are \emph{stationary}, i.e., they maintain a constant
variance over time. This makes AR processes useful models of uncertainty.
}
\seealso{
For usage examples see \code{\link[=sts_fit_with_hmc]{sts_fit_with_hmc()}}, \code{\link[=sts_forecast]{sts_forecast()}}, \code{\link[=sts_decompose_by_component]{sts_decompose_by_component()}}.

Other sts: 
\code{\link{sts_additive_state_space_model}()},
\code{\link{sts_autoregressive_state_space_model}()},
\code{\link{sts_constrained_seasonal_state_space_model}()},
\code{\link{sts_dynamic_linear_regression}()},
\code{\link{sts_dynamic_linear_regression_state_space_model}()},
\code{\link{sts_linear_regression}()},
\code{\link{sts_local_level}()},
\code{\link{sts_local_level_state_space_model}()},
\code{\link{sts_local_linear_trend}()},
\code{\link{sts_local_linear_trend_state_space_model}()},
\code{\link{sts_seasonal}()},
\code{\link{sts_seasonal_state_space_model}()},
\code{\link{sts_semi_local_linear_trend}()},
\code{\link{sts_semi_local_linear_trend_state_space_model}()},
\code{\link{sts_smooth_seasonal}()},
\code{\link{sts_smooth_seasonal_state_space_model}()},
\code{\link{sts_sparse_linear_regression}()},
\code{\link{sts_sum}()}
}
\concept{sts}
