% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimator_keys.R
\name{graph_keys}
\alias{graph_keys}
\title{Standard Names to Use for Graph Collections}
\usage{
graph_keys()
}
\description{
The standard library uses various well-known names to collect and retrieve
values associated with a graph.
}
\details{
For example, the \code{tf$Optimizer} subclasses default to optimizing the
variables collected under\code{graph_keys()$TRAINABLE_VARIABLES} if \code{NULL} is
specified, but it is also possible to pass an explicit list of variables.

The following standard keys are defined:
\itemize{
\item \code{GLOBAL_VARIABLES}: the default collection of \code{Variable} objects, shared
across distributed environment (model variables are subset of these). See
\code{tf$global_variables} for more details. Commonly, all \code{TRAINABLE_VARIABLES}
variables will be in \code{MODEL_VARIABLES}, and all \code{MODEL_VARIABLES} variables
will be in \code{GLOBAL_VARIABLES}.
\item \code{LOCAL_VARIABLES}: the subset of \code{Variable} objects that are local to each
machine. Usually used for temporarily variables, like counters. Note: use
\code{tf$contrib$framework$local_variable} to add to this collection.
\item \code{MODEL_VARIABLES}: the subset of \code{Variable} objects that are used in the
model for inference (feed forward). Note: use
\code{tf$contrib$framework$model_variable} to add to this collection.
\item \code{TRAINABLE_VARIABLES}: the subset of \code{Variable} objects that will be
trained by an optimizer. See \code{tf$trainable_variables} for more details.
\item \code{SUMMARIES}: the summary \code{Tensor} objects that have been created in the
graph. See \code{tf$summary$merge_all} for more details.
\item \code{QUEUE_RUNNERS}: the \code{QueueRunner} objects that are used to produce input
for a computation. See \code{tf$train$start_queue_runners} for more details.
\item \code{MOVING_AVERAGE_VARIABLES}: the subset of \code{Variable} objects that will also
keep moving averages. See \code{tf$moving_average_variables} for more details.
\item \code{REGULARIZATION_LOSSES}: regularization losses collected during graph
construction. The following standard keys are defined, but their
collections are \strong{not} automatically populated as many of the others are:
\itemize{
\item \code{WEIGHTS}
\item \code{BIASES}
\item \code{ACTIVATIONS}
}
}
}
\examples{
\dontrun{
graph_keys()
graph_keys()$LOSSES
}

}
\seealso{
Other utility functions: 
\code{\link{latest_checkpoint}()}
}
\concept{utility functions}
