% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_npairs}
\alias{loss_npairs}
\title{Npairs loss}
\usage{
loss_npairs(name = "npairs_loss")
}
\arguments{
\item{name}{Optional name for the op.}
}
\value{
npairs_loss: float scalar.
}
\description{
Computes the npairs loss between `y_true` and `y_pred`.
}
\details{
Npairs loss expects paired data where a pair is composed of samples from
the same labels and each pairs in the minibatch have different labels.
The loss takes each row of the pair-wise similarity matrix, `y_pred`,
as logits and the remapped multi-class labels, `y_true`, as labels. The
similarity matrix `y_pred` between two embedding matrices `a` and `b`
with shape `[batch_size, hidden_size]` can be computed as follows:
```
# y_pred = a * b^T
y_pred = tf$matmul(a, b, transpose_a=FALSE, transpose_b=TRUE)
```
See: http://www.nec-labs.com/uploads/images/Department-Images/MediaAnalytics/papers/nips16_npairmetriclearning.pdf
}
