% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_sigmoid_focal_crossentropy}
\alias{loss_sigmoid_focal_crossentropy}
\title{Sigmoid focal crossentropy loss}
\usage{
loss_sigmoid_focal_crossentropy(
  from_logits = FALSE,
  alpha = 0.25,
  gamma = 2,
  reduction = tf$keras$losses$Reduction$NONE,
  name = "sigmoid_focal_crossentropy"
)
}
\arguments{
\item{from_logits}{If logits are provided then convert the predictions into probabilities}

\item{alpha}{balancing factor.}

\item{gamma}{modulating factor.}

\item{reduction}{(Optional) Type of tf$keras$losses$Reduction to apply.
Default value is SUM_OVER_BATCH_SIZE.}

\item{name}{(Optional) name for the loss.}
}
\value{
Weighted loss float `Tensor`. If `reduction` is `NONE`,this has the same shape as `y_true`;
otherwise, it is scalar.
}
\description{
Sigmoid focal crossentropy loss
}
\examples{

\dontrun{
keras_model_sequential() \%>\%
  layer_dense(4, input_shape = c(784)) \%>\%
  compile(
    optimizer = 'sgd',
    loss=loss_sigmoid_focal_crossentropy(),
    metrics='accuracy'
  )
}


}
