% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_random_hsv_in_yiq}
\alias{img_random_hsv_in_yiq}
\title{Random hsv in yiq}
\usage{
img_random_hsv_in_yiq(
  image,
  max_delta_hue = 0,
  lower_saturation = 1,
  upper_saturation = 1,
  lower_value = 1,
  upper_value = 1,
  seed = NULL,
  name = NULL
)
}
\arguments{
\item{image}{RGB image or images. Size of the last dimension must be 3.}

\item{max_delta_hue}{float. Maximum value for the random delta_hue.
Passing 0 disables adjusting hue.}

\item{lower_saturation}{float. Lower bound for the random scale_saturation.}

\item{upper_saturation}{float. Upper bound for the random scale_saturation.}

\item{lower_value}{float. Lower bound for the random scale_value.}

\item{upper_value}{float. Upper bound for the random scale_value.}

\item{seed}{An operation-specific seed. It will be used in conjunction with
the graph-level seed to determine the real seeds that will be used in this
operation. Please see the documentation of set_random_seed for its interaction
with the graph-level random seed.}

\item{name}{A name for this operation (optional).}
}
\value{
3-D float tensor of shape `[height, width, channels]`.
}
\description{
Adjust hue, saturation, value of an RGB image randomly in YIQ color
}
\details{
space. Equivalent to `adjust_yiq_hsv()` but uses a `delta_h` randomly
picked in the interval `[-max_delta_hue, max_delta_hue]`, a
`scale_saturation` randomly picked in the interval
`[lower_saturation, upper_saturation]`, and a `scale_value`
randomly picked in the interval `[lower_saturation, upper_saturation]`.
}
\section{Raises}{

ValueError: if `max_delta`, `lower_saturation`, `upper_saturation`,
`lower_value`, or `upper_value` is invalid.
}

\examples{

\dontrun{
delta = 0.5
lower_saturation = 0.1
upper_saturation = 0.9
lower_value = 0.2
upper_value = 0.8
rand_hsvinyiq = img_random_hsv_in_yiq(img, delta,
lower_saturation, upper_saturation,
lower_value, upper_value)
)
}


}
