% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq2seq.R
\name{gather_tree_from_array}
\alias{gather_tree_from_array}
\title{Gather tree from array}
\usage{
gather_tree_from_array(t, parent_ids, sequence_length)
}
\arguments{
\item{t}{A stacked `TensorArray` of size `max_time` that contains `Tensor`s of
shape `[batch_size, beam_width, s]` or `[batch_size * beam_width, s]` where `s`
is the depth shape.}

\item{parent_ids}{The parent ids of shape `[max_time, batch_size, beam_width]`.}

\item{sequence_length}{The sequence length of shape `[batch_size, beam_width]`.}
}
\value{
A `Tensor` which is a stacked `TensorArray` of the same size and type as
`t` and where beams are sorted in each `Tensor` according to `parent_ids`.
}
\description{
Calculates the full beams for `TensorArray`s.
}
