% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback_tqdm_progress_bar}
\alias{callback_tqdm_progress_bar}
\title{TQDM Progress Bar}
\usage{
callback_tqdm_progress_bar(
  metrics_separator = " - ",
  overall_bar_format = NULL,
  epoch_bar_format = "{n_fmt}/{total_fmt}{bar} ETA: {remaining}s - {desc}",
  update_per_second = 10,
  leave_epoch_progress = TRUE,
  leave_overall_progress = TRUE,
  show_epoch_progress = TRUE,
  show_overall_progress = TRUE
)
}
\arguments{
\item{metrics_separator}{(string) Custom separator between metrics. Defaults to ' - '}

\item{overall_bar_format}{(string format) Custom bar format for overall (outer) progress
bar, see https://github.com/tqdm/tqdm#parameters for more detail.
By default: '{l_bar}{bar} {n_fmt}/{total_fmt} ETA: {remaining}s,  {rate_fmt}{postfix}'}

\item{epoch_bar_format}{(string format) Custom bar format for epoch (inner) progress bar,
see https://github.com/tqdm/tqdm#parameters for more detail.}

\item{update_per_second}{(int) Maximum number of updates in the epochs bar per second, this
is to prevent small batches from slowing down training. Defaults to 10.}

\item{leave_epoch_progress}{(bool) TRUE to leave epoch progress bars}

\item{leave_overall_progress}{(bool) TRUE to leave overall progress bar}

\item{show_epoch_progress}{(bool) FALSE to hide epoch progress bars}

\item{show_overall_progress}{(bool) FALSE to hide overall progress bar}
}
\value{
None
}
\description{
TQDM Progress Bar
}
\details{
TQDM Progress Bar for Tensorflow Keras.
}
\examples{

\dontrun{
model \%>\% fit(
x_train, y_train,
batch_size = 128,
epochs = 4,
validation_split = 0.2,
verbose = 0,
callbacks = callback_tqdm_progress_bar()
)
}



}
