% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-tools.R
\name{patch_table_env}
\alias{patch_table_env}
\title{patch table environment}
\usage{
patch_table_env(article_dir)
}
\arguments{
\item{article_dir}{path to the directory which contains tex article}
}
\value{
patches table environments in LaTeX file and also backs up the old file before modification
}
\description{
function to modify env and commands in TeX using GNU sed

These are due to the pandoc's limitations and ease in conversion.
}
\details{
changes are made to :
1. table* environment to table environment
2. \\multicolumn to \\multicolumnx
\\multicolumnx is redefined in Metafix.sty as
\\renewcommand\{\\multicolumnx\}[3]\{\\multicolumn\{#1\}\{c\}\{#3\}\}
}
\examples{
article_dir <- system.file("examples/article",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"article",sep="/")
texor::patch_table_env(your_article_path)
unlink(your_article_folder,recursive = TRUE)
}
