% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_occurrences_by_grade.R
\name{h_append_grade_groups}
\alias{h_append_grade_groups}
\title{Helper function for \code{s_count_occurrences_by_grade()}}
\usage{
h_append_grade_groups(
  grade_groups,
  refs,
  remove_single = TRUE,
  only_grade_groups = FALSE
)
}
\arguments{
\item{grade_groups}{(named \code{list} of \code{character})\cr list containing groupings of grades.}

\item{refs}{(named \code{list} of \code{numeric})\cr named list where each name corresponds to a reference grade level
and each entry represents a count.}

\item{remove_single}{(\code{flag})\cr \code{TRUE} to not include the elements of one-element grade groups
in the the output list; in this case only the grade groups names will be included in the output. If
\code{only_grade_groups} is set to \code{TRUE} this argument is ignored.}

\item{only_grade_groups}{(\code{flag})\cr whether only the specified grade groups should be
included, with individual grade rows removed (\code{TRUE}), or all grades and grade groups
should be displayed (\code{FALSE}).}
}
\value{
Formatted list of grade groupings.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper function for \code{\link[=s_count_occurrences_by_grade]{s_count_occurrences_by_grade()}} to insert grade groupings into list with
individual grade frequencies. The order of the final result follows the order of \code{grade_groups}.
The elements under any-grade group (if any), i.e. the grade group equal to \code{refs} will be moved to
the end. Grade groups names must be unique.
}
\examples{
h_append_grade_groups(
  list(
    "Any Grade" = as.character(1:5),
    "Grade 1-2" = c("1", "2"),
    "Grade 3-4" = c("3", "4")
  ),
  list("1" = 10, "2" = 20, "3" = 30, "4" = 40, "5" = 50)
)

h_append_grade_groups(
  list(
    "Any Grade" = as.character(5:1),
    "Grade A" = "5",
    "Grade B" = c("4", "3")
  ),
  list("1" = 10, "2" = 20, "3" = 30, "4" = 40, "5" = 50)
)

h_append_grade_groups(
  list(
    "Any Grade" = as.character(1:5),
    "Grade 1-2" = c("1", "2"),
    "Grade 3-4" = c("3", "4")
  ),
  list("1" = 10, "2" = 5, "3" = 0)
)

}
