% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_prune.R
\name{tar_prune}
\alias{tar_prune}
\title{Remove targets that are no longer part of the pipeline.}
\usage{
tar_prune(
  cloud = TRUE,
  batch_size = 1000L,
  verbose = TRUE,
  callr_function = callr::r,
  callr_arguments = targets::tar_callr_args_default(callr_function),
  envir = parent.frame(),
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{cloud}{Logical of length 1, whether to delete objects
from the cloud if applicable (e.g. AWS, GCP). If \code{FALSE},
files are not deleted from the cloud.}

\item{batch_size}{Positive integer between 1 and 1000,
number of target definition objects to delete
from the cloud with each HTTP API request.
Currently only supported for AWS.
Cannot be more than 1000.}

\item{verbose}{Logical of length 1, whether to print console messages
to show progress when deleting each batch of targets from each
cloud bucket. Batched deletion with verbosity is currently only supported
for AWS.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}

\item{envir}{An environment, where to run the target R script
(default: \verb{_targets.R}) if \code{callr_function} is \code{NULL}.
Ignored if \code{callr_function} is anything other than \code{NULL}.
\code{callr_function} should only be \code{NULL} for debugging and
testing purposes, not for serious runs of a pipeline, etc.

The \code{envir} argument of \code{\link[=tar_make]{tar_make()}} and related
functions always overrides
the current value of \code{tar_option_get("envir")} in the current R session
just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
\code{NULL} except if \code{callr_function} is \code{callr::r_bg}, in which case
a handle to the \code{callr} background process is returned. Either way,
the value is invisibly returned.
}
\description{
Remove target values from \verb{_targets/objects/} and the cloud
and remove target metadata from \verb{_targets/meta/meta}
for targets that are no longer part of the pipeline.
}
\details{
\code{tar_prune()} is useful if you recently worked through
multiple changes to your project and are now trying to
discard irrelevant data while keeping the results that still matter.
Global objects and local files with \code{format = "file"} outside the
data store are unaffected. Also removes \verb{_targets/scratch/},
which is only needed while \code{\link[=tar_make]{tar_make()}}, \code{\link[=tar_make_clustermq]{tar_make_clustermq()}},
or \code{\link[=tar_make_future]{tar_make_future()}} is running. To list the targets that will be
pruned without actually removing anything, use \code{\link[=tar_prune_list]{tar_prune_list()}}.
}
\section{Storage access}{

Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.
}

\section{Cloud target data versioning}{

Some buckets in Amazon S3 or Google Cloud Storage are "versioned",
which means they track historical versions of each data object.
If you use \code{targets} with cloud storage
(\url{https://books.ropensci.org/targets/cloud-storage.html})
and versioning is turned on, then \code{targets} will record each
version of each target in its metadata.

Functions like \code{\link[=tar_read]{tar_read()}}
and \code{\link[=tar_load]{tar_load()}} load the version recorded in the local metadata,
which may not be the same as the "current" version of the
object in the bucket. Likewise, functions \code{\link[=tar_delete]{tar_delete()}}
and \code{\link[=tar_destroy]{tar_destroy()}} only remove
the version ID of each target as recorded in the local
metadata.

If you want to interact with the \emph{latest} version of an object
instead of the version ID recorded in the local metadata,
then you will need to delete the object from the metadata.
\enumerate{
\item Make sure your local copy of the metadata is current and
up to date. You may need to run \code{\link[=tar_meta_download]{tar_meta_download()}} or
\code{\link[=tar_meta_sync]{tar_meta_sync()}} first.
\item Run \code{\link[=tar_unversion]{tar_unversion()}} to remove the recorded version IDs of
your targets in the local metadata.
\item With the version IDs gone from the local metadata,
functions like \code{\link[=tar_read]{tar_read()}} and \code{\link[=tar_destroy]{tar_destroy()}} will use the
\emph{latest} version of each target data object.
\item Optional: to back up the local metadata file with the version IDs
deleted, use \code{\link[=tar_meta_upload]{tar_meta_upload()}}.
}
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  library(targets)
  library(tarchetypes)
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make()
# Remove some targets from the pipeline.
tar_script(list(tar_target(y1, 1 + 1)), ask = FALSE)
# Keep only the remaining targets in the data store.
tar_prune()
})
}
}
\seealso{
tar_prune_inspect

Other clean: 
\code{\link{tar_delete}()},
\code{\link{tar_destroy}()},
\code{\link{tar_invalidate}()},
\code{\link{tar_prune_list}()},
\code{\link{tar_unversion}()}
}
\concept{clean}
