% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_stratify.R
\name{learner_stratify}
\alias{learner_stratify}
\title{Construct stratified learner}
\usage{
learner_stratify(
  formula,
  learner,
  stratify = NULL,
  info = NULL,
  learner.args = list(),
  ...
)
}
\arguments{
\item{formula}{formula specifying outcome and design matrix}

\item{learner}{(learner) \link{learner} object}

\item{stratify}{(character,formula) variables to stratify by}

\item{info}{optional description of the model}

\item{learner.args}{(list) optional arguments to the learner constructor}

\item{...}{additional arguments passed to the learner constructor}
}
\value{
learner object
}
\description{
This function creates a stratified learner from an existing
\link{learner} wrapper function such as \link{learner_glm} or \link{learner_xgboost}. The
stratification variable can be specified either using the \code{stratify}
argument (which can be given as a string "a" or a formula , for example ~
I(a==0)), or it can be defined as a special term directly in the formula, y
~ ... + stratify(a). The formula will subsequently be passed to the
\code{learner_} wrapper without the stratify special term.
}
\examples{
simdata <- function(n=1000) {
  a <- rbinom(n, 1, 0.5)
  x <- rnorm(n)
  y <- rbinom(n, 1, plogis(-1 + a + a * x))
  data.frame(y, a, x)
}
d <- simdata()

lr <- learner_stratify(
  y ~ x + stratify(a),
  learner_glm,
  family=binomial()
)
lr$estimate(d)
lr$predict(head(d))
}
