% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{style_title}
\alias{style_title}
\title{style_title}
\usage{
style_title(
  tbl,
  background_color = "#ffffff",
  text_color = "#000000",
  font_size = NULL,
  bold = FALSE,
  italic = FALSE,
  openxlsx_style = NULL,
  gt_style = NULL
)
}
\arguments{
\item{tbl}{tablespan table}

\item{background_color}{hex code for the background color}

\item{text_color}{hex code for the text color}

\item{font_size}{font size}

\item{bold}{set to TRUE for bold}

\item{italic}{set to TRUE for italic}

\item{openxlsx_style}{optional custom openxlsx style. When provided, all other arguments are ignored}

\item{gt_style}{optional custom gt style. When provided, all other arguments are ignored}
}
\value{
the tablespan table with added styles
}
\description{
Set the style used for the title of the tablespan table.
}
\details{
The styling for openxlsx and gt works differently:

- openxlsx_style must be a style object created with openxlsx::createStyle. This style
will then be applied to the title
- gt_style must be a list of gt::tab_style objects to be applied to the table
}
\examples{
library(tablespan)
library(dplyr)
data("mtcars")

# We want to report the following table:
summarized_table <- mtcars |>
  group_by(cyl, vs) |>
  summarise(N = n(),
            mean_hp = mean(hp),
            sd_hp = sd(hp),
            mean_wt = mean(wt),
            sd_wt = sd(wt))

# Create a tablespan:
tbl <- tablespan(data = summarized_table,
                 formula = Cylinder:cyl + Engine:vs ~
                   N +
                   (`Horse Power` = Mean:mean_hp + SD:sd_hp) +
                   (`Weight` = Mean:mean_wt + SD:sd_wt),
                 title = "Motor Trend Car Road Tests",
                 subtitle = "A table created with tablespan",
                 footnote = "Data from the infamous mtcars data set.")

tbl |>
  style_title(bold = TRUE) |>
  as_gt()
}
