% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_survshap.R
\name{model_survshap}
\alias{model_survshap}
\alias{model_survshap.surv_explainer}
\title{Global SHAP Values}
\usage{
model_survshap(explainer, ...)

\method{model_survshap}{surv_explainer}(
  explainer,
  new_observation = NULL,
  y_true = NULL,
  N = NULL,
  calculation_method = "kernelshap",
  aggregation_method = "integral",
  output_type = "survival",
  ...
)
}
\arguments{
\item{explainer}{an explainer object - model preprocessed by the \code{explain()} function}

\item{...}{additional parameters, passed to internal functions}

\item{new_observation}{new observations for which predictions need to be explained}

\item{y_true}{a two element numeric vector or matrix of one row and two columns, the first element being the true observed time and the second the status of the observation, used for plotting}

\item{N}{a positive integer, number of observations used as the background data}

\item{calculation_method}{a character, either \code{"kernelshap"} for use of \code{kernelshap} library (providing faster Kernel SHAP with refinements), \code{"exact_kernel"} for exact Kernel SHAP estimation, or \code{"treeshap"} for use of \code{treeshap} library (efficient implementation to compute SHAP values for tree-based models).}

\item{aggregation_method}{a character, either \code{"integral"}, \code{"integral_absolute"}, \code{"mean_absolute"}, \code{"max_absolute"}, or \code{"sum_of_squares"}}

\item{output_type}{a character, either \code{"survival"} or \code{"chf"}. Determines which type of prediction should be used for explanations.}
}
\value{
An object of class \code{aggregated_surv_shap} containing the computed global SHAP values.
}
\description{
This function computes global SHAP values.
}
\details{
If specifying \code{y_true}, also \code{new_observation} must be specified.
Using the argument \code{new_observation}, global SHAP values are computed for the provided data. Otherwise,
global SHAP values are computed for the data, the \code{explainer} was trained with.
}
\examples{
\donttest{
veteran <- survival::veteran
rsf_ranger <- ranger::ranger(
    survival::Surv(time, status) ~ .,
    data = veteran,
    respect.unordered.factors = TRUE,
    num.trees = 100,
    mtry = 3,
    max.depth = 5
)
rsf_ranger_exp <- explain(
    rsf_ranger,
    data = veteran[, -c(3, 4)],
    y = survival::Surv(veteran$time, veteran$status),
    verbose = FALSE
)

ranger_global_survshap <- model_survshap(
    explainer = rsf_ranger_exp,
    new_observation = veteran[
        c(1:4, 17:20, 110:113, 126:129),
        !colnames(veteran) \%in\% c("time", "status")
    ],
    y_true = survival::Surv(
        veteran$time[c(1:4, 17:20, 110:113, 126:129)],
        veteran$status[c(1:4, 17:20, 110:113, 126:129)]
    ),
    aggregation_method = "integral",
    calculation_method = "kernelshap",
)
plot(ranger_global_survshap)
plot(ranger_global_survshap, geom = "beeswarm")
plot(ranger_global_survshap, geom = "profile", color_variable = "karno")
}

}
