% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vim_brier.R
\name{vim_brier}
\alias{vim_brier}
\title{Estimate Brier score VIM}
\usage{
vim_brier(
  time,
  event,
  approx_times,
  landmark_times,
  f_hat,
  fs_hat,
  S_hat,
  G_hat,
  cf_folds,
  ss_folds,
  sample_split,
  scale_est = FALSE,
  alpha = 0.05
)
}
\arguments{
\item{time}{\code{n x 1} numeric vector of observed
follow-up times If there is censoring, these are the minimum of the
event and censoring times.}

\item{event}{\code{n x 1} numeric vector of status indicators of
whether an event was observed. Defaults to a vector of 1s, i.e. no censoring.}

\item{approx_times}{Numeric vector of length J1 giving times at which to
approximate integrals.}

\item{landmark_times}{Numeric vector of length J2 giving
times at which to estimate Brier score}

\item{f_hat}{Full oracle predictions (n x J1 matrix)}

\item{fs_hat}{Residual oracle predictions (n x J1 matrix)}

\item{S_hat}{Estimates of conditional event time survival function (n x J2 matrix)}

\item{G_hat}{Estimate of conditional censoring time survival function (n x J2 matrix)}

\item{cf_folds}{Numeric vector of length n giving cross-fitting folds}

\item{ss_folds}{Numeric vector of length n giving sample-splitting folds}

\item{sample_split}{Logical indicating whether or not to sample split}

\item{scale_est}{Logical, whether or not to force the VIM estimate to be nonnegative}

\item{alpha}{The level at which to compute confidence intervals and hypothesis tests. Defaults to 0.05}
}
\value{
A data frame giving results, with the following columns:
\item{landmark_time}{Time at which AUC is evaluated.}
\item{est}{VIM point estimate.}
\item{var_est}{Estimated variance of the VIM estimate.}
\item{cil}{Lower bound of the VIM confidence interval.}
\item{ciu}{Upper bound of the VIM confidence interval.}
\item{cil_1sided}{Lower bound of a one-sided confidence interval.}
\item{p}{p-value corresponding to a hypothesis test of null importance.}
\item{large_predictiveness}{Estimated predictiveness of the large oracle prediction function.}
\item{small_predictiveness}{Estimated predictiveness of the small oracle prediction function.}
\item{vim}{VIM type.}
\item{large_feature_vector}{Group of features available for the large oracle prediction function.}
\item{small_feature_vector}{Group of features available for the small oracle prediction function.}
}
\description{
Estimate Brier score VIM
}
\seealso{
\link{vim} for example usage
}
