% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DR_pseudo_outcome_regression.R
\name{DR_pseudo_outcome_regression}
\alias{DR_pseudo_outcome_regression}
\title{Generate oracle prediction function estimates using doubly-robust pseudo-outcome regression with SuperLearner}
\usage{
DR_pseudo_outcome_regression(
  time,
  event,
  X,
  newX,
  approx_times,
  S_hat,
  G_hat,
  newtimes,
  outcome,
  SL.library,
  V
)
}
\arguments{
\item{time}{\code{n x 1} numeric vector of observed
follow-up times. If there is censoring, these are the minimum of the
event and censoring times.}

\item{event}{\code{n x 1} numeric vector of status indicators of
whether an event was observed.}

\item{X}{\code{n x p} data.frame of observed covariate values}

\item{newX}{\code{m x p} data.frame of new observed covariate
values at which to obtain \code{m} predictions for the estimated algorithm.
Must have the same names and structure as \code{X}.}

\item{approx_times}{Numeric vector of length J2 giving times at which to
approximate integral appearing in the pseudo-outcomes}

\item{S_hat}{\code{n x J2} matrix of conditional event time survival function estimates}

\item{G_hat}{\code{n x J2} matrix of conditional censoring time survival function estimates}

\item{newtimes}{Numeric vector of times at which to generate oracle prediction function estimates}

\item{outcome}{Outcome type, either \code{"survival_probability"} or \code{"restricted_survival_time"}}

\item{SL.library}{Super Learner library}

\item{V}{Number of cross-validation folds, to be passed to \code{SuperLearner}}
}
\value{
Matrix of predictions.
}
\description{
Generate oracle prediction function estimates using doubly-robust pseudo-outcome regression with SuperLearner
}
