% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qw_stats.R
\name{qw_stats}
\alias{qw_stats}
\title{Calculate summary statistics}
\usage{
qw_stats(dates, values, rec_start, rec_end, by = "day")
}
\arguments{
\item{dates}{A vector of dates to be evaluated. Must be of class \code{Date}.}

\item{values}{A numeric vector to be evaluated. Must be of class \code{numeric}.}

\item{rec_start}{The start date of the recording period. Must be of class \code{Date}.}

\item{rec_end}{The end date of the recording period. Must be of class \code{Date}.}

\item{by}{The time interval to use for the evaluation. One of "day", "week", "month", "quarter",
or "year". Default is "day".}
}
\value{
A data frame with 1 row and 22 columns:
\tabular{lll}{
\strong{Name} \tab \strong{Type} \tab \strong{Description} \cr
rec_startDate \tab Date \tab Start date of ideal record \cr
rec_endDate \tab Date \tab End date of ideal record \cr
n_miss_dates \tab integer \tab Number of missing time periods (as specified by \code{by}) within the
recording period. \cr
pct_complete_dates \tab numeric \tab Percentage of the time period (as specified by \code{by})
covered by the \code{dates} \cr
value_startDate \tab Date \tab Date of the first \code{values} in the record \cr
value_endDate \tab Date \tab Date of the last \code{values} in the record \cr
n_value \tab integer \tab Number of non-NA \code{values} \cr
n_pos \tab integer \tab Number of non-negative \code{values} in the data \cr
pos_pct \tab numeric \tab Percentage of non-negative \code{values} in the data \cr
n_neg \tab integer \tab Number of negative \code{values} in the data \cr
neg_pct \tab numeric \tab Percentage of negative \code{values} in the data \cr
n_na \tab integer \tab Number of NA \code{values} in the data \cr
na_pct \tab numeric \tab Percentage of NA \code{values} in the data \cr
tot_pct \tab numeric \tab sum of \code{pos_pct}, \code{neg_pct}, and \code{na_pct} \cr
Min. \tab numeric \tab Minimum of \code{values} \cr
Q1 \tab numeric \tab 25th percentile of \code{values} \cr
Median \tab numeric \tab Median (50th percentile) of \code{values} \cr
Mean \tab numeric \tab Mean of \code{values} \cr
Q3 \tab numeric \tab 75th percentile of \code{values} \cr
Max. \tab numeric \tab Maximum of \code{values} \cr
std \tab numeric \tab Standard deviation of \code{values} \cr
vari \tab numeric \tab Variance of \code{values} \cr
}
}
\description{
Evaluate the completeness of a record compared to a hypothetical "ideal" record and simple
statistics. Intended to be used on a (near) daily water quality record.
}
\examples{
data <- data.frame(
  date_col = as.Date(c("2020-01-01", "2020-01-02", "2020-01-03", "2020-01-04", "2020-01-05")),
  var_col = c(1.2, 2.3, 3.1, NA, 4.5)
)
rec_start <- as.Date("2020-01-01")
rec_end <- as.Date("2020-01-05")
qw_stats(data$date_col, data$var_col, rec_start, rec_end, by = "day")

data_no_missing <- data.frame(
  date_col = as.Date(c("2020-01-01", "2020-01-02", "2020-01-03", "2020-01-04", "2020-01-05")),
  var_col = c(1.2, 2.3, 3.1, 4.5, 5.6)
)
qw_stats(data_no_missing$date_col, data_no_missing$var_col, rec_start, rec_end, by = "day")

data_weekly <- data.frame(
  date_col = as.Date(c("2020-01-01", "2020-01-08", "2020-01-15", "2020-01-22", "2020-01-29")),
  var_col = c(1.2, 2.3, 3.1, 4.5, 5.6)
)
qw_stats(data_weekly$date_col, data_weekly$var_col, rec_start, rec_end, by = "week")

}
