% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{all_same}
\alias{all_same}
\title{Test if All Elements are the Same}
\usage{
all_same(x)
}
\arguments{
\item{x}{atomic vector, list vector, or list.}
}
\value{
logical vector of length 1 specifying whether all the elements in \code{x}
are the same (TRUE) or not (FALSE).
}
\description{
\code{all_same} tests if all elements are the same. The elements could be either
from an atomic vector, list vector, or list. If \code{x} does not have any unique
values (e.g., NULL), then FALSE is returned.
}
\details{
The machine precision of \code{all_same} for numeric vectors is the same as
\code{unique}. This can causes a problem for some floating-point numbers.
}
\examples{
all_same(rep.int("a", times = 10))
all_same(rep.int(1, times = 10))
all_same(c(1.0000000, 1.0000001, 0.9999999)) # machine precision good for most cases
all_same(1) # works for vectors of length 1
}
