% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text2.R
\name{text2}
\alias{text2}
\title{Enhanced alternative to text()}
\arguments{
\item{x, y}{coordinates for text placement}

\item{labels}{text to display}

\item{align}{alignment in relation to x coordinate ('left','center','right')}

\item{bg}{background color}

\item{cex}{character expansion factor}

\item{pad}{left/right padding in percentage (e.g., .03)}

\item{pad_v}{top/bottom padding in percentage (e.g., .25)}

\item{...}{Additional arguments passed to \code{\link[graphics]{text}}.}
}
\value{
No return value, called for side effects. Adds text with an optional 
  background rectangle to an existing plot.
}
\description{
Adds to text() optional background color and verbal alignment (align='center')
}
\examples{
# Create a simple plot
plot(1:10, 1:10, type = "n", main = "text2() - Alignment & Color")

# Alignment respect to x=5
text2(5, 8, "align='left' from 5", align = "left", bg = "yellow1")
text2(5, 7, "align='right' from 5", align = "right", bg = "blue", col = "white")
text2(5, 6, "align='center' from 5", align = "center", bg = "black", col = "white")
abline(v = 5, lty = 2)

# Multiple labels with different alignments
text2(c(2, 5, 8), c(5, 5, 5), 
      labels = c("Left", "Center", "Right"),
      align = c("left", "center", "right"),
      bg = c("pink", "lightblue", "lightgreen"))

# Text with custom font color (passed through ...)
text2(5, 3, "Red Text", col = "red", bg = "white")

# Padding examples
plot(1:10, 1:10, type = "n", main = "Padding Examples")

# Default padding (pad=0.03, pad_v=0.25)
text2(5, 8, "Default padding", bg = "lightblue")

# More horizontal padding
text2(5, 6, "Wide padding", pad = 0.2, bg = "lightgreen")

# More vertical padding
text2(5, 4, "Tall padding", pad_v = 0.8, bg = "lightyellow")

# Both padding increased
text2(5, 2, "Extra padding", pad = 0.15, pad_v = 0.6, bg = "pink")
}
