% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.lc.stdmean.bs}
\alias{ci.lc.stdmean.bs}
\title{Confidence interval for a standardized linear contrast of means in a
between-subjects design}
\usage{
ci.lc.stdmean.bs(alpha, m, sd, n, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{vector of estimated group means}

\item{sd}{vector of estimated group standard deviation}

\item{n}{vector of sample sizes}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns a 3-row matrix. The columns are:
\itemize{
\item Estimate - estimated standardized linear contrast
\item adj Estimate - bias adjusted standardized linear contrast estimate
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for a population standardized linear contrast
of means in a between-subjects design. The unweighted standardizer is
recommended in experimental designs. The weighted standardizer is
recommended in nonexperimental designs with simple random sampling. The
group 1 standardizer is useful in both experimental and nonexperimental
designs. Equality of variances is not assumed.

For more details, see Section 3.4 of Bonett (2021, Volume 1)
}
\examples{
m <- c(6.94, 7.15, 4.60, 3.68)
sd <- c(2.21, 2.83, 2.29, 1.90)
n <- c(40, 40, 40, 40)
v <- c(.5, .5, -.5, -.5)
ci.lc.stdmean.bs(.05, m, sd, n, v)

# Should return:
#                          Estimate adj Estimate      SE     LL     UL
# Unweighted standardizer:   1.2459       1.2399 0.17621 0.9005 1.5912 
# Weighted standardizer:     1.2459       1.2399 0.17313 0.9065 1.5852
# Group 1 standardizer:      1.3145       1.2890 0.22515 0.8732 1.7558


}
\references{
\insertRef{Bonett2008}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
