% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotStab.R
\name{plotStability}
\alias{plotStability}
\title{Plot of edge and causal path stability.}
\usage{
plotStability(listOfFronts = NULL, threshold = NULL, stableCausal = NULL,
  stableCausal_l1 = NULL, stableEdge = NULL, longitudinal = NULL)
}
\arguments{
\item{listOfFronts}{\code{\link{list}} of models including their fitness
and subset index.}

\item{threshold}{threshold of stability selection. The default is 0.6.}

\item{stableCausal}{\code{\link{list}} of causal path stability
for the whole range of model complexities.}

\item{stableCausal_l1}{\code{\link{list}} of causal path stability
of length 1 for the whole range of model complexities.}

\item{stableEdge}{\code{\link{list}} of edge stability
for the whole range of model complexities.}

\item{longitudinal}{\code{TRUE} for longitudinal data,
and \code{FALSE} cross-sectional data.}
}
\value{
Plot of causal path and edge stability for
every pair of variables, including plots of all edge stabilites
and all cauasl path stabilities.
}
\description{
Plot each of the stability of causal path and edge including the threshold
of stability and model complexity.
}
\examples{
\donttest{
the_data <- crossdata6V
numSubset <- 1
num_iteration <- 5
num_pop <- 10
mut_rate <- 0.075
cross_rate <- 0.85
longi <- FALSE
num_time <- 1
the_co <- "covariance"
#assummed that variable 5 does not cause variables 1, 2, and 3
cons_matrix <- matrix(c(5, 1, 5, 2, 5, 3), 3, 2, byrow=TRUE)
th <- 0.1
to_plot <- FALSE

result <- stableSpec(theData=the_data, nSubset=numSubset,
iteration=num_iteration,
nPop=num_pop, mutRate=mut_rate, crossRate=cross_rate,
longitudinal=longi, numTime=num_time,
co=the_co, consMatrix=cons_matrix, threshold=th, toPlot=to_plot)

plotStability(listOfFronts=result$listOfFronts, threshold=th,
stableCausal=result$causalStab,
stableCausal_l1=result$causalStab_l1,
stableEdge=result$edgeStab,
longitudinal=longi)
}
}
\author{
Ridho Rahmadi \email{r.rahmadi@cs.ru.nl}
}
