% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ammi.R
\name{ammi}
\alias{ammi}
\alias{ammi.default}
\title{Additive Main Effects and Multiplicative Interaction (AMMI)}
\usage{
ammi(.data, .y, .rep, .gen, .env)

\method{ammi}{default}(.data, .y, .rep, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\value{
Stability Measures
}
\description{
Performs Additive Main Effects and Multiplicative Interaction (AMMI) Analysis for Genotypes by Environment Interaction (GEI)
}
\examples{

data(ge_data)
Yield.ammi <-
     ammi(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
      )
Yield.ammi



}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         }
}
