% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_single_rate.R
\name{power_single_rate}
\alias{power_single_rate}
\title{Detectable Event Rate with Specified Power and Sample Size}
\usage{
power_single_rate(subjects, power)
}
\arguments{
\item{subjects}{Integer or vector of integers. Sample size(s).}

\item{power}{Numeric or vector of numerics. Desired power(s), between 0 and 1.}
}
\value{
A matrix of class \code{power_single_rate} with columns:
\describe{
\item{n}{Sample size}
\item{power}{Requested power}
\item{proportion}{Minimum detectable event rate to observe at least one event}
}
}
\description{
Estimates the minimum true proportion of events needed to detect at least one
event, given a sample size and desired statistical power.
}
\examples{
power_single_rate(30, 0.9)
power_single_rate(c(30, 50, 100), 0.9)

}
