% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-transformations.R
\name{qts2sqts}
\alias{qts2sqts}
\title{QTS Transformation to Smoothed Quaternion Time Series}
\usage{
qts2sqts(x, spar = 0)
}
\arguments{
\item{x}{An object of class \link{qts}.}

\item{spar}{smoothing parameter, typically (but not necessarily) in
   \eqn{(0,1]}.  When \code{spar} is specified, the coefficient
   \eqn{\lambda} of the integral of the squared second derivative in the
   fit (penalized log likelihood) criterion is a monotone function of
   \code{spar}, see the details below.  Alternatively \code{lambda} may
   be specified instead of the \emph{scale free} \code{spar}=\eqn{s}.}
}
\value{
An object of class \code{qts} storing the smoothed QTS.
}
\description{
This function smooths a given QTS using a b-spline functional representation.
}
\examples{
qts2sqts(vespa64$igp[[1]], spar = 0.3)
}
