#' SQL WHERE statement.
#'
#' This class represents a SQL WHERE statement, used to filter results in
#' SELECT, UPDATE, and DELETE statements.
#'
#' @examples
#' # Create a WHERE statement with a simple expression:
#' expr <- ExprBinOp$new(ExprValue$new("age"), ">=", ExprValue$new(18))
#' where <- StmtWhere$new(expr)
#'
#' # Use the created WHERE statement inside a SELECT query:
#' query <- QuerySelect$new(StmtSelectAll$new(),
#'                          from = StmtFrom$new("users"))
#' query$add(where)
#'
#' @import R6
#' @import chk
#' @include Statement.R
#' @export
StmtWhere <- R6::R6Class("StmtWhere",
  inherit = Statement,
  public = list(

    #' @description
    #' Initializer.
    #' @param expr The expression to evaluate.
    #' @return Nothing.
    initialize = function(expr) {
      chk::chk_is(expr, "Expr")
      private$expr <- expr
      return(invisible(NULL))
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      tokens <- list()
      private$expr$enableParenthesis(FALSE)
      expr_tokens <- private$expr$getTokens()
      if (length(expr_tokens) > 0L)
        tokens <- c(tokens, .where, .spc, expr_tokens)
      return(tokens)
    }
  ),
  private = list(
    expr = NULL
  )
)
