#' Composed Expression class.
#'
#' This abstract class is used as a parent class for ExprBinOp and ExprCommOp.
#'
#' @examples
#' # No example provided, as this class is abstract.
#'
#' @import R6
#' @include Expr.R
ExprComp <- R6::R6Class("ExprComp",
  inherit = Expr,
  public = list(

    #' @description
    #' Initializer.
    #' @param paren Set to TRUE to enable parenthesis around the expression.
    #' @return Nothing.
    initialize = function(paren = TRUE) {
      chk::chk_flag(paren)
      private$paren <- paren
      return(invisible(NULL))
    },

    #' @description
    #' Disable parenthesis around expression.
    #' @param enabled Set to TRUE to enable parenthesis and FALSE to disable
    #'                them.
    #' @return Nothing.
    enableParenthesis = function(enabled) {
      chk::chk_flag(enabled)
      private$paren <- enabled
      return(invisible(NULL))
    }
  ),
  private = list(
    paren = TRUE
  )
)
