% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.R
\name{sim_slx_error}
\alias{sim_slx_error}
\title{Simulate Spatially Lagged X Error Model}
\usage{
sim_slx_error(u, xb, wxg, listw, lambda = 0.5, model = c("sar", "ma"))
}
\arguments{
\item{u}{an error vector}

\item{xb}{predicted x values as calculated by \code{make_xb()}}

\item{wxg}{predicted spatial lag effect as calculated by \code{make_wxg()}}

\item{listw}{a \code{listw} object generated with \code{sim_grid_listw()}.}

\item{lambda}{a value value between -1 and 1. The spatial autoregressive coefficient for the error term.}

\item{model}{default \code{"sar"}. Which model should be simulated. Provide \code{"ma"} for the moving average.}
}
\value{
A numeric vector
}
\description{
Simulate Spatially Lagged X Error Model
}
\references{
\href{https://pysal.org/spreg/generated/spreg.dgp.dgp_slxerror.html#spreg.dgp.dgp_slxerror}{\code{spreg.dgp.dgp_slxerror}}
}
