% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_threshold.R
\name{est_delta}
\alias{est_delta}
\title{This function select the optimal thresholding level delta}
\usage{
est_delta(
  data,
  method = c("cv", "qiu"),
  operator = c("hard", "soft", "scad", "al")
)
}
\arguments{
\item{data}{The data matrix.}

\item{method}{The choice of method to select the optimal threshold level.}

\item{operator}{The choice of thresholding operator.}
}
\value{
The optimal threshold level.
}
\description{
This function select the optimal thresholding level delta
}
\examples{
## generate data from a block diagonal covariance matrix structure
n <- 50
p <- 30
data.true.cov <- block.true.cov(p)
data <- sampleMVN(n, data.true.cov, sparse=TRUE)
## select the optimal thresholding level delta
delta <- est_delta(data, method='cv', operator='scad')
}
