% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_km.R
\name{span_km}
\alias{span_km}
\title{Kempf–Memmel GMVP Spanning Test}
\usage{
span_km(R1, R2)
}
\arguments{
\item{R1}{Numeric matrix of benchmark returns, dimension \eqn{T \times N}.}

\item{R2}{Numeric matrix of test-asset returns, dimension \eqn{T \times K}.}
}
\value{
A named list with components:
\describe{
  \item{\code{pval}}{P-value for the F-statistic under the null.}
  \item{\code{stat}}{F-statistic value.}
  \item{\code{H0}}{Null hypothesis description, \code{"GMVP(bmk) = GMVP(full)"}.}
}
}
\description{
Tests whether the Global Minimum Variance Portfolio (GMVP) of the combined
(benchmark + test) universe equals the GMVP of the benchmark assets alone.
Following Kempf & Memmel (2006), the null assesses whether adding new assets
improves the minimum-variance frontier.
}
\details{
The null hypothesis \eqn{H_0} is that augmenting the benchmark set with the
test assets does not change the GMVP weights (\eqn{\Delta = 0}), i.e.,
the GMVP of the full universe coincides with that of the benchmark subset.
The test is implemented via a linear restriction on coefficients in an
equivalent regression representation, yielding an \eqn{F}-statistic.
}
\examples{
set.seed(123)
R1 <- matrix(rnorm(300), 100, 3)  # benchmarks: T=100, N=3
R2 <- matrix(rnorm(200), 100, 2)  # tests:      T=100, K=2
ans <- span_km(R1, R2)
ans$pval; ans$stat; ans$H0

}
\references{
\insertRef{KempfMemmel2006}{spantest} \cr
}
\seealso{
Other Variance Spanning Tests: 
\code{\link{span_f2}()}
}
\concept{Variance Spanning Tests}
