% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_gl_ad.R
\name{span_gl_ad}
\alias{span_gl_ad}
\title{Gungor–Luger Joint Mean–Variance Spanning Test (2016)}
\usage{
span_gl_ad(R1, R2, control = list())
}
\arguments{
\item{R1}{Numeric matrix of benchmark returns, dimension \eqn{T \times N}.}

\item{R2}{Numeric matrix of test-asset returns, dimension \eqn{T \times K}.}

\item{control}{List of options:
\describe{
  \item{\code{totsim}}{Number of MC simulations (default \code{500}).}
  \item{\code{pval_thresh}}{Significance level for decisions (default \code{0.05}).}
  \item{\code{do_trace}}{Logical; print progress (default \code{TRUE}).}
}}
}
\value{
A list with components:
\describe{
  \item{\code{pval_LMC}}{Least-Favorable MC p-value.}
  \item{\code{pval_BMC}}{Balanced MC p-value.}
  \item{\code{stat}}{Observed \eqn{F_{\max}} statistic.}
  \item{\code{Decisions}}{Decision code: \code{1} = Accept, \code{0} = Reject, \code{NA} = Inconclusive.}
  \item{\code{Decisions_string}}{Text label: \code{"Accept"}, \code{"Reject"}, or \code{"Inconclusive"}.}
  \item{\code{H0}}{Null hypothesis description, \code{"alpha = 0 and delta = 0"}.}
}
}
\description{
Tests the joint null \eqn{H_0:\ \alpha = 0,\ \delta = 0} that benchmark assets
span both intercepts and slopes of the test assets, allowing for
heteroskedasticity, serial dependence, and time-varying covariances.
Following Gungor & Luger (2016), the procedure uses a Monte Carlo (MC)
test based on an \eqn{F_{\max}} statistic with residual sign-flip simulations,
yielding Least-Favorable (LMC) and Balanced (BMC) MC p-values and a
three-way decision rule.
}
\details{
LMC/BMC follow Gungor & Luger’s MC framework with residual sign-flip draws under
the null. The rule is: Accept if \code{pval_LMC > alpha}; Reject if
\code{pval_BMC <= alpha}; otherwise Inconclusive. This approach is robust in
high-dimensional and time-varying volatility settings where classical joint
spanning tests can be unreliable.
}
\examples{
set.seed(123)
R1 <- matrix(rnorm(300), 100, 3)
R2 <- matrix(rnorm(200), 100, 2)
out <- span_gl_ad(R1, R2, control = list(totsim = 100, do_trace = FALSE))
out$Decisions_string; out$pval_LMC; out$pval_BMC

}
\references{
\insertRef{GungorLuger2016}{spantest} \cr
}
\seealso{
Other Joint Mean-Variance Spanning Tests: 
\code{\link{span_hk}()}
}
\concept{Joint Mean-Variance Spanning Tests}
