% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.validate.R
\name{som.nn.validate}
\alias{som.nn.validate}
\title{Predict class labels for a validation dataset}
\usage{
som.nn.validate(model, x)
}
\arguments{
\item{model}{model of type \code{SOMnn}.}

\item{x}{data.fame with validation data. Samples are requested as rows.
\code{x} must include the same columns as the data.frame with which the model
have been trained originally.
A column with correct class labels is needed. The column with class
lables is selected by the slot \code{class.idx} of the model.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{    S4 object of type \code{\link{SOMnn}} with the unchanged model and the
            test statistics for the test data.
}\if{html}{\out{</div>}}
}
\description{
A model of type \code{SOMnn} is tested with a validation dataset. The dataset must
include a column with correct class labels.
The model is used to predict class labels. Confusion table,
specificity, sensitivity and accuracy for each class are calculated.
}
\details{
Parameters stored in the model are applied for k-NN-like prediction. If necessary
the parameters can be changed by \code{\link{som.nn.set}} before testing.

The funcion is only a wrapper and actually calls \code{som.nn.continue} with the test data and
without training (i.e. \code{len = 0}).
}
\examples{
## get example data and add class labels:
data(iris)
species <- iris$Species

## train with default radius = diagonal / 2:
rlen <- 500
som <- som.nn.train(iris, class.col = "Species", kernel = "internal",
                    xdim = 15, ydim = 9, alpha = 0.2, len = rlen, 
                    norm = TRUE, toroidal = FALSE)


## continue training with different alpha and radius;
som <- som.nn.continue(som, iris, alpha = 0.02, len=500, radius = 5)
som <- som.nn.continue(som, iris, alpha = 0.02, len=500, radius = 2)

## predict some samples:
unk <- iris[,!(names(iris) \%in\% "Species")]

setosa <- unk[species=="setosa",]
setosa <- setosa[sample(nrow(setosa), 20),]

versicolor <- unk[species=="versicolor",]
versicolor <- versicolor[sample(nrow(versicolor), 20),]

virginica <- unk[species=="virginica",]
virginica <- virginica[sample(nrow(virginica), 20),]

p <- predict(som, unk)
head(p)

## plot:
plot(som)
dev.off()
plot(som, predict = predict(som, setosa))
plot(som, predict = predict(som, versicolor), add = TRUE, pch.col = "magenta", pch = 17)
plot(som, predict = predict(som, virginica), add = TRUE, pch.col = "white", pch = 8)

}
